<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            ['name' => 'site_name', 'value' => 'FlyWhats'],
            ['name' => 'site_description', 'value' => 'Professional SMS & WhatsApp Marketing Platform'],
            ['name' => 'site_keywords', 'value' => 'sms, whatsapp, marketing, bulk messaging, api'],
            ['name' => 'site_logo', 'value' => 'uploads/system/logo.png'],
            ['name' => 'site_favicon', 'value' => 'uploads/system/favicon.ico'],
            ['name' => 'mail_host', 'value' => ''],
            ['name' => 'mail_port', 'value' => '587'],
            ['name' => 'mail_username', 'value' => ''],
            ['name' => 'mail_password', 'value' => ''],
            ['name' => 'mail_encryption', 'value' => 'tls'],
            ['name' => 'mail_from', 'value' => 'noreply@flywhats.com'],
            ['name' => 'mail_name', 'value' => 'FlyWhats'],
            ['name' => 'default_currency', 'value' => 'USD'],
            ['name' => 'default_language', 'value' => '1'],
            ['name' => 'default_timezone', 'value' => 'UTC'],
            ['name' => 'registration_enabled', 'value' => '1'],
            ['name' => 'email_verification', 'value' => '1'],
            ['name' => 'default_package', 'value' => '1'],
            ['name' => 'whatsapp_enabled', 'value' => '1'],
            ['name' => 'sms_enabled', 'value' => '1'],
            ['name' => 'api_enabled', 'value' => '1'],
            ['name' => 'social_facebook', 'value' => ''],
            ['name' => 'social_twitter', 'value' => ''],
            ['name' => 'social_instagram', 'value' => ''],
            ['name' => 'social_linkedin', 'value' => ''],
            ['name' => 'maintenance_mode', 'value' => '0'],
            ['name' => 'google_analytics', 'value' => ''],
            ['name' => 'recaptcha_enabled', 'value' => '0'],
            ['name' => 'recaptcha_site_key', 'value' => ''],
            ['name' => 'recaptcha_secret_key', 'value' => ''],
        ];

        foreach ($settings as $setting) {
            DB::table('settings')->updateOrInsert(['name' => $setting['name']], $setting);
        }
    }
}
