<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PackageSeeder extends Seeder
{
    public function run(): void
    {
        $packages = [
            [
                'id' => 1,
                'name' => 'Free Plan',
                'permissions' => json_encode([
                    'sms' => true,
                    'whatsapp' => true,
                    'api_access' => true,
                ]),
                'price' => 0,
                'send_limit' => 100,
                'receive_limit' => 100,
                'ussd_limit' => 10,
                'notification_limit' => 50,
                'contact_limit' => 500,
                'device_limit' => 1,
                'key_limit' => 1,
                'webhook_limit' => 1,
                'action_limit' => 5,
                'scheduled_limit' => 10,
                'wa_account_limit' => 1,
                'wa_send_limit' => 100,
                'wa_receive_limit' => 100,
                'wa_scheduled_limit' => 10,
                'partner_commission' => 0,
                'hidden' => 0,
                'footermark' => 1,
            ],
            [
                'id' => 2,
                'name' => 'Starter',
                'permissions' => json_encode([
                    'sms' => true,
                    'whatsapp' => true,
                    'api_access' => true,
                    'bulk_messaging' => true,
                ]),
                'price' => 9.99,
                'send_limit' => 1000,
                'receive_limit' => 1000,
                'ussd_limit' => 50,
                'notification_limit' => 200,
                'contact_limit' => 5000,
                'device_limit' => 3,
                'key_limit' => 3,
                'webhook_limit' => 3,
                'action_limit' => 20,
                'scheduled_limit' => 50,
                'wa_account_limit' => 2,
                'wa_send_limit' => 1000,
                'wa_receive_limit' => 1000,
                'wa_scheduled_limit' => 50,
                'partner_commission' => 10,
                'hidden' => 0,
                'footermark' => 0,
            ],
            [
                'id' => 3,
                'name' => 'Professional',
                'permissions' => json_encode([
                    'sms' => true,
                    'whatsapp' => true,
                    'api_access' => true,
                    'bulk_messaging' => true,
                    'advanced_reports' => true,
                    'auto_replies' => true,
                ]),
                'price' => 29.99,
                'send_limit' => 10000,
                'receive_limit' => 10000,
                'ussd_limit' => 200,
                'notification_limit' => 1000,
                'contact_limit' => 50000,
                'device_limit' => 10,
                'key_limit' => 10,
                'webhook_limit' => 10,
                'action_limit' => 100,
                'scheduled_limit' => 200,
                'wa_account_limit' => 5,
                'wa_send_limit' => 10000,
                'wa_receive_limit' => 10000,
                'wa_scheduled_limit' => 200,
                'partner_commission' => 15,
                'hidden' => 0,
                'footermark' => 0,
            ],
            [
                'id' => 4,
                'name' => 'Enterprise',
                'permissions' => json_encode([
                    'sms' => true,
                    'whatsapp' => true,
                    'api_access' => true,
                    'bulk_messaging' => true,
                    'advanced_reports' => true,
                    'auto_replies' => true,
                    'ai_integration' => true,
                    'priority_support' => true,
                ]),
                'price' => 99.99,
                'send_limit' => -1, // Unlimited
                'receive_limit' => -1,
                'ussd_limit' => -1,
                'notification_limit' => -1,
                'contact_limit' => -1,
                'device_limit' => -1,
                'key_limit' => -1,
                'webhook_limit' => -1,
                'action_limit' => -1,
                'scheduled_limit' => -1,
                'wa_account_limit' => -1,
                'wa_send_limit' => -1,
                'wa_receive_limit' => -1,
                'wa_scheduled_limit' => -1,
                'partner_commission' => 20,
                'hidden' => 0,
                'footermark' => 0,
            ],
        ];

        foreach ($packages as $package) {
            DB::table('packages')->updateOrInsert(['id' => $package['id']], $package);
        }
    }
}
