<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LanguageSeeder extends Seeder
{
    public function run(): void
    {
        $languages = [
            ['id' => 1, 'name' => 'English', 'iso' => 'en', 'rtl' => 0],
            ['id' => 2, 'name' => 'العربية', 'iso' => 'ar', 'rtl' => 1],
            ['id' => 3, 'name' => 'Français', 'iso' => 'fr', 'rtl' => 0],
            ['id' => 4, 'name' => 'Español', 'iso' => 'es', 'rtl' => 0],
            ['id' => 5, 'name' => 'Português', 'iso' => 'pt', 'rtl' => 0],
            ['id' => 6, 'name' => 'Türkçe', 'iso' => 'tr', 'rtl' => 0],
            ['id' => 7, 'name' => 'Deutsch', 'iso' => 'de', 'rtl' => 0],
            ['id' => 8, 'name' => 'Italiano', 'iso' => 'it', 'rtl' => 0],
            ['id' => 9, 'name' => 'हिंदी', 'iso' => 'hi', 'rtl' => 0],
            ['id' => 10, 'name' => 'اردو', 'iso' => 'ur', 'rtl' => 1],
        ];

        foreach ($languages as $lang) {
            DB::table('languages')->updateOrInsert(['id' => $lang['id']], $lang);
        }
    }
}
