<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GatewaySeeder extends Seeder
{
    public function run(): void
    {
        $gateways = [
            [
                'id' => 1,
                'name' => 'Android Gateway',
                'callback' => null,
                'pricing' => json_encode(['price_per_sms' => 0]),
                'controller' => 'android',
                'enabled' => 1,
            ],
            [
                'id' => 2,
                'name' => 'Twilio',
                'callback' => 'twilio/callback',
                'pricing' => json_encode(['price_per_sms' => 0.0075]),
                'controller' => 'twilio',
                'enabled' => 0,
            ],
            [
                'id' => 3,
                'name' => 'Nexmo (Vonage)',
                'callback' => 'nexmo/callback',
                'pricing' => json_encode(['price_per_sms' => 0.0065]),
                'controller' => 'nexmo',
                'enabled' => 0,
            ],
            [
                'id' => 4,
                'name' => 'Plivo',
                'callback' => 'plivo/callback',
                'pricing' => json_encode(['price_per_sms' => 0.0055]),
                'controller' => 'plivo',
                'enabled' => 0,
            ],
        ];

        foreach ($gateways as $gateway) {
            DB::table('gateways')->updateOrInsert(['id' => $gateway['id']], $gateway);
        }
    }
}
