<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('conversation_assignments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid')->comment('معرف المستخدم المالك');
            $table->string('phone', 50)->comment('رقم الهاتف للمحادثة');
            $table->integer('assigned_to')->comment('معرف عضو الفريق المعين');
            $table->integer('assigned_by')->nullable()->comment('من قام بالتعيين');
            $table->boolean('is_first_responder')->default(false)->comment('هل هو صاحب أول رد');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            
            $table->unique(['uid', 'phone']);
            $table->index(['uid', 'assigned_to']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('conversation_assignments');
    }
};
