<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('messenger_notes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('phone', 50);
            $table->text('note');
            $table->integer('created_by');
            $table->enum('created_by_type', ['user', 'staff'])->default('user');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            
            $table->index(['uid', 'phone']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('messenger_notes');
    }
};
