<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('reports_cache', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->date('report_date');
            $table->integer('sent')->default(0);
            $table->integer('received')->default(0);
            $table->integer('wa_sent')->default(0);
            $table->integer('wa_received')->default(0);
            $table->timestamp('create_date')->useCurrent();
            
            $table->unique(['uid', 'report_date']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reports_cache');
    }
};
