<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('marketing', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('type');
            $table->text('users')->nullable();
            $table->string('roles', 255)->nullable();
            $table->text('title');
            $table->longText('content');
            $table->string('image', 255)->nullable();
            $table->timestamp('create_date')->useCurrent();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('marketing');
    }
};
