<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('commissions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('pid');
            $table->unsignedBigInteger('sid');
            $table->unsignedBigInteger('mid');
            $table->string('did', 255);
            $table->float('original_amount');
            $table->float('commission_amount');
            $table->string('currency', 10);
            $table->timestamp('create_date')->useCurrent();
            
            $table->index(['pid', 'sid']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('commissions');
    }
};
