<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->string('roles', 255)->nullable();
            $table->string('slug', 255)->unique();
            $table->tinyInteger('logged')->default(0);
            $table->string('name', 255);
            $table->longText('content')->nullable();
            $table->timestamp('create_date')->useCurrent();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pages');
    }
};
