<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('tid', 255);
            $table->string('type', 50);
            $table->string('price', 50);
            $table->string('currency', 10);
            $table->string('duration', 50)->nullable();
            $table->longText('data')->nullable();
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
