<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('quota', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid')->unique();
            $table->integer('sent')->default(0);
            $table->integer('received')->default(0);
            $table->integer('wa_sent')->default(0);
            $table->integer('wa_received')->default(0);
            $table->integer('ussd')->default(0);
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('quota');
    }
};
