<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wa_sent', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('cid')->default(0);
            $table->unsignedBigInteger('uid');
            $table->integer('sid')->nullable();
            $table->string('wid', 255);
            $table->text('unique');
            $table->string('phone', 50);
            $table->string('group', 100)->nullable();
            $table->text('message');
            $table->text('media_url')->nullable();
            $table->string('type', 50)->default('text');
            $table->tinyInteger('status')->default(1);
            $table->tinyInteger('priority')->default(2);
            $table->tinyInteger('api')->default(0);
            $table->timestamp('create_date')->useCurrent();
            $table->string('message_id', 100)->nullable();
            $table->string('wa_name', 255)->nullable();
            $table->text('wa_profile_pic')->nullable();
            $table->boolean('is_deleted')->default(false);
            $table->boolean('is_edited')->default(false);
            
            $table->index('uid');
            $table->index('cid');
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wa_sent');
    }
};
