<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wa_campaigns', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->integer('sid')->nullable();
            $table->string('wid', 255);
            $table->text('unique');
            $table->string('type', 50)->default('text');
            $table->tinyInteger('status')->default(1);
            $table->string('name', 255);
            $table->integer('contacts')->default(0);
            $table->integer('processed')->default(0);
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wa_campaigns');
    }
};
