<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wa_accounts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('name', 255)->nullable();
            $table->unsignedBigInteger('wsid');
            $table->string('wid', 255);
            $table->text('unique');
            $table->tinyInteger('receive_chats')->default(2);
            $table->tinyInteger('random_send')->default(1);
            $table->integer('random_min')->default(1);
            $table->integer('random_max')->default(5);
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
            $table->index('wsid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wa_accounts');
    }
};
