<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('scheduled', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('did', 255);
            $table->tinyInteger('sim')->default(1);
            $table->tinyInteger('repeat')->default(1);
            $table->string('groups', 255)->nullable();
            $table->string('numbers', 255)->nullable();
            $table->string('name', 255);
            $table->text('message');
            $table->dateTime('send_date');
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('scheduled');
    }
};
