<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sent', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('cid')->default(0);
            $table->unsignedBigInteger('uid');
            $table->string('did', 255)->nullable();
            $table->integer('gateway')->default(0);
            $table->tinyInteger('api')->default(0);
            $table->tinyInteger('sim')->default(1);
            $table->tinyInteger('mode')->default(1);
            $table->tinyInteger('priority')->default(2);
            $table->string('phone', 50);
            $table->text('message');
            $table->tinyInteger('status')->default(1);
            $table->string('status_code', 255)->nullable();
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
            $table->index('cid');
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sent');
    }
};
