<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tags', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->integer('sid')->nullable();
            $table->string('name', 255);
            $table->string('color', 7)->default('#6c757d');
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tags');
    }
};
