<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('contacts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->integer('sid')->nullable();
            $table->string('groups', 255);
            $table->text('sources')->nullable();
            $table->text('tags')->nullable();
            $table->string('phone', 50);
            $table->string('name', 255);
            $table->timestamp('create_date')->useCurrent();
            $table->string('wa_name', 255)->nullable();
            $table->string('wa_profile_pic', 500)->nullable();
            
            $table->index('uid');
            $table->index('phone');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contacts');
    }
};
