<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->integer('send_limit')->default(0);
            $table->integer('receive_limit')->default(0);
            $table->integer('ussd_limit')->default(0);
            $table->integer('contact_limit')->default(0);
            $table->integer('device_limit')->default(0);
            $table->integer('key_limit')->default(0);
            $table->integer('webhook_limit')->default(0);
            $table->integer('action_limit')->default(0);
            $table->integer('scheduled_limit')->default(0);
            $table->integer('wa_send_limit')->default(0);
            $table->integer('wa_receive_limit')->default(0);
            $table->integer('wa_account_limit')->default(0);
            $table->string('name', 255);
            $table->float('price');
            $table->text('footermark')->nullable();
            $table->tinyInteger('hidden')->default(0);
            $table->tinyInteger('is_default')->default(0);
            $table->text('services');
            $table->timestamp('create_date')->useCurrent();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
