<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('languages', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('rtl')->default(0);
            $table->char('iso', 4);
            $table->integer('order')->default(0);
            $table->string('name', 255);
            $table->timestamp('create_date')->useCurrent();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('languages');
    }
};
