<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->integer('role')->default(1);
            $table->string('email', 255);
            $table->string('password', 255);
            $table->float('credits')->default(0);
            $table->float('earnings')->default(0);
            $table->string('name', 255);
            $table->string('country', 10)->nullable();
            $table->tinyInteger('language')->default(1);
            $table->string('theme_color', 50)->nullable();
            $table->longText('providers')->nullable();
            $table->tinyInteger('alertsound')->default(1);
            $table->tinyInteger('suspended')->default(0);
            $table->string('timezone', 100)->nullable();
            $table->string('formatting', 100)->nullable();
            $table->tinyInteger('partner')->default(2);
            $table->tinyInteger('confirmed')->default(2);
            $table->timestamp('create_date')->useCurrent();
            $table->string('avatar', 255)->nullable();
            $table->rememberToken();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
