<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WaServer extends Model
{
    protected $table = 'wa_servers';
    public $timestamps = false;

    protected $fillable = ['name', 'address', 'port', 'secret', 'enabled'];

    protected $hidden = ['secret'];

    public function getFullAddressAttribute(): string
    {
        return "{$this->address}:{$this->port}";
    }
}
