<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WaScheduled extends Model
{
    protected $table = 'wa_scheduled';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'sid', 'wid', 'unique', 'repeat_mode', 'groups',
        'numbers', 'message_type', 'message', 'attachment', 'send_date', 'status'
    ];

    protected $casts = [
        'send_date' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(WaAccount::class, 'wid', 'wid');
    }
}
