<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Voucher extends Model
{
    protected $table = 'vouchers';
    public $timestamps = false;

    protected $fillable = ['code', 'pid', 'duration', 'used'];

    public function package(): BelongsTo
    {
        return $this->belongsTo(Package::class, 'pid', 'id');
    }

    public function isUsed(): bool
    {
        return $this->used === 1;
    }
}
