<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Utility extends Model
{
    protected $table = 'utilities';
    public $timestamps = false;

    protected $fillable = ['name', 'value'];

    /**
     * الحصول على قيمة إعداد
     */
    public static function getValue(string $name, $default = null)
    {
        $utility = self::where('name', $name)->first();
        return $utility ? $utility->value : $default;
    }

    /**
     * تعيين قيمة إعداد
     */
    public static function setValue(string $name, $value): void
    {
        self::updateOrCreate(
            ['name' => $name],
            ['value' => $value]
        );
    }
}
