<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Ussd extends Model
{
    protected $table = 'ussd';
    public $timestamps = false;

    protected $fillable = ['uid', 'did', 'sim', 'code', 'response', 'status'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
