<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Unsubscribed extends Model
{
    protected $table = 'unsubscribed';
    public $timestamps = false;

    protected $fillable = ['uid', 'phone', 'type'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
