<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TemplateCategory extends Model
{
    protected $table = 'template_categories';
    public $timestamps = false;

    protected $fillable = ['uid', 'sid', 'name'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function templates(): HasMany
    {
        return $this->hasMany(Template::class, 'category_id', 'id');
    }
}
