<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Tag extends Model
{
    protected $table = 'tags';
    public $timestamps = false;
    const CREATED_AT = 'created';
    const UPDATED_AT = null;

    protected $fillable = ['uid', 'sid', 'name', 'color'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
