<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Staff extends Authenticatable
{
    protected $table = 'staff';
    public $timestamps = false;

    protected $fillable = ['uid', 'sid', 'name', 'email', 'password'];

    protected $hidden = ['password'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function notifications()
    {
        return $this->hasMany(StaffNotification::class, 'sid', 'id');
    }
}
