<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Sent extends Model
{
    protected $table = 'sent';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'sid', 'did', 'gateway', 'mode', 'sim', 'phone',
        'message', 'status', 'priority', 'api'
    ];

    // Status constants
    const STATUS_PENDING = 1;
    const STATUS_SENT = 2;
    const STATUS_DELIVERED = 3;
    const STATUS_FAILED = 4;

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function device(): BelongsTo
    {
        return $this->belongsTo(Device::class, 'did', 'did');
    }
}
