<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Order extends Model
{
    protected $table = 'orders';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'pid', 'provider', 'price', 'currency', 'duration', 'ref', 'status'
    ];

    protected $casts = [
        'price' => 'float',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function package(): BelongsTo
    {
        return $this->belongsTo(Package::class, 'pid', 'id');
    }
}
