<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MessengerSetting extends Model
{
    protected $table = 'messenger_settings';
    public $timestamps = false;

    protected $fillable = ['uid', 'sid', 'key', 'value'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public static function getForUser(int $uid, string $key, $default = null)
    {
        $setting = static::where('uid', $uid)->where('key', $key)->first();
        return $setting ? $setting->value : $default;
    }
}
