<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MessengerNumberException extends Model
{
    protected $table = 'messenger_number_exceptions';
    public $timestamps = false;
    const CREATED_AT = 'created_at';

    protected $fillable = ['uid', 'staff_id'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function staff(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id');
    }
}
