<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MessengerNote extends Model
{
    protected $table = 'messenger_notes';
    public $timestamps = false;

    protected $fillable = ['uid', 'sid', 'phone', 'account', 'note'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
