<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class HiddenConversation extends Model
{
    protected $table = 'hidden_conversations';
    public $timestamps = false;
    const CREATED_AT = 'created_at';

    protected $fillable = ['uid', 'phone', 'hidden_by'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
