<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FlowStep extends Model
{
    protected $table = 'flow_steps';

    protected $fillable = [
        'flow_id', 'type', 'subtype', 'config', 'position_x', 'position_y', 'order'
    ];

    protected $casts = [
        'config' => 'array'
    ];

    public function flow()
    {
        return $this->belongsTo(Flow::class);
    }
}
