<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Contact extends Model
{
    protected $table = 'contacts';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'sid', 'groups', 'sources', 'tags', 'phone', 'name',
        'wa_name', 'wa_profile_pic', 'wa_synced_at'
    ];

    protected $casts = [
        'wa_synced_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    // Get groups as array
    public function getGroupsArrayAttribute(): array
    {
        return $this->groups ? explode(',', $this->groups) : [];
    }
}
