<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApiKey extends Model
{
    protected $table = 'api_keys';

    protected $fillable = [
        'uid', 'name', 'key', 'permissions', 'status', 'last_used_at'
    ];

    protected $hidden = [
        'key'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'uid');
    }
}
