<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AiKey extends Model
{
    protected $table = 'ai_keys';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'name', 'prompt', 'post_prompt', 'model', 'history',
        'max_tokens', 'vision', 'transcription', 'apikey', 'provider'
    ];

    protected $hidden = ['apikey'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
