<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Package;

class MiscController extends Controller
{
    public function packages()
    {
        $packages = Package::where('status', 1)
            ->where('hidden', 0)
            ->orderBy('price', 'asc')
            ->get();

        return view('misc.packages', compact('packages'));
    }

    public function gatewayRates()
    {
        // Get gateway rates from config or database
        $rates = config('rates.gateways', []);

        return view('misc.rates-gateways', compact('rates'));
    }

    public function partnerRates()
    {
        $partnerRates = config('rates.partners', []);

        return view('misc.rates-partners', compact('partnerRates'));
    }
}
