<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class DocsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        return view('docs.index');
    }

    public function webhooks()
    {
        return view('docs.webhooks');
    }

    public function actions()
    {
        return view('docs.actions');
    }

    public function android()
    {
        return view('docs.android');
    }

    public function partners()
    {
        return view('docs.partners');
    }

    public function admin()
    {
        if (auth()->user()->role != 1) {
            abort(403);
        }

        return view('docs.admin');
    }
}
