<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Webhook;

class WebhookController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $webhooks = Webhook::where('uid', auth()->id())->get();
        return view('dashboard.tools.webhooks', compact('webhooks'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'url' => 'required|url'
        ]);

        Webhook::create([
            'uid' => auth()->id(),
            'name' => $request->name,
            'url' => $request->url,
            'events' => is_array($request->events) ? implode(',', $request->events) : '',
            'secret' => $request->secret,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('dashboard.tools.webhooks')->with('success', __('webhook_created'));
    }

    public function update(Request $request, $id)
    {
        $webhook = Webhook::where('uid', auth()->id())->findOrFail($id);

        $webhook->update([
            'name' => $request->name,
            'url' => $request->url,
            'events' => is_array($request->events) ? implode(',', $request->events) : '',
            'secret' => $request->secret,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('dashboard.tools.webhooks')->with('success', __('webhook_updated'));
    }

    public function destroy($id)
    {
        Webhook::where('uid', auth()->id())->findOrFail($id)->delete();
        return redirect()->route('dashboard.tools.webhooks')->with('success', __('webhook_deleted'));
    }

    public function test($id)
    {
        $webhook = Webhook::where('uid', auth()->id())->findOrFail($id);

        try {
            $response = \Http::timeout(10)->post($webhook->url, [
                'event' => 'test',
                'timestamp' => time(),
                'data' => ['message' => 'Test webhook from ' . config('app.name')]
            ]);

            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => __('webhook_test_success')]);
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }

        return response()->json(['success' => false, 'message' => __('webhook_test_failed')]);
    }
}
