<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\WaScheduled;
use App\Models\WaAccount;
use App\Models\Group;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WaScheduledController extends Controller
{
    public function index(Request $request)
    {
        $query = WaScheduled::where('uid', Auth::id());
        
        if ($request->status) {
            $query->where('status', $request->status);
        }
        
        $scheduled = $query->orderBy('send_date', 'desc')->paginate(25);
        $accounts = WaAccount::where('uid', Auth::id())->where('status', 1)->get();
        $groups = Group::where('uid', Auth::id())->get();
        
        return view('dashboard.whatsapp.scheduled', compact('scheduled', 'accounts', 'groups'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'unique' => 'required|string',
            'numbers' => 'required|string',
            'message' => 'required|string',
            'send_date' => 'required|date',
        ]);

        $account = WaAccount::where('unique', $request->unique)->first();

        WaScheduled::create([
            'uid' => Auth::id(),
            'wid' => $account->wid ?? null,
            'unique' => $request->unique,
            'repeat_mode' => $request->repeat_mode ?? 0,
            'groups' => $request->groups ? implode(',', $request->groups) : null,
            'numbers' => $request->numbers,
            'message_type' => $request->message_type ?? 1,
            'message' => $request->message,
            'attachment' => $request->attachment,
            'send_date' => $request->send_date,
            'status' => 1,
        ]);

        return back()->with('success', __('messages.scheduled_created'));
    }

    public function update(Request $request, WaScheduled $scheduled)
    {
        $scheduled->update($request->only(['numbers', 'message', 'send_date', 'repeat_mode', 'attachment']));
        return back()->with('success', __('messages.scheduled_updated'));
    }

    public function destroy(WaScheduled $scheduled)
    {
        $scheduled->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
