<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\WaSent;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WaQueueController extends Controller
{
    public function index(Request $request)
    {
        $messages = WaSent::where('uid', Auth::id())
            ->where('status', 1) // Pending
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.whatsapp.queue', compact('messages'));
    }

    public function clear()
    {
        WaSent::where('uid', Auth::id())->where('status', 1)->delete();
        return back()->with('success', __('messages.queue_cleared'));
    }

    public function destroy(WaSent $message)
    {
        if ($message->status == 1) {
            $message->delete();
        }
        return back()->with('success', __('messages.deleted'));
    }
}
