<?php

namespace App\Http\Controllers\Dashboard\Tools;

use App\Http\Controllers\Controller;
use App\Models\TemplateCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TemplateCategoryController extends Controller
{
    public function index(Request $request)
    {
        $categories = TemplateCategory::where('uid', Auth::id())
            ->withCount('templates')
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.tools.template_categories', compact('categories'));
    }

    public function store(Request $request)
    {
        $request->validate(['name' => 'required|string|max:255']);
        TemplateCategory::create([
            'uid' => Auth::id(),
            'name' => $request->name,
        ]);
        return back()->with('success', __('messages.category_created'));
    }

    public function update(Request $request, TemplateCategory $category)
    {
        $request->validate(['name' => 'required|string|max:255']);
        $category->update(['name' => $request->name]);
        return back()->with('success', __('messages.category_updated'));
    }

    public function destroy(TemplateCategory $category)
    {
        $category->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
