<?php

namespace App\Http\Controllers\Dashboard\Tools;

use App\Http\Controllers\Controller;
use App\Models\Logger;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoggerController extends Controller
{
    public function index(Request $request)
    {
        $logs = Logger::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(50);
            
        return view('dashboard.tools.logger', compact('logs'));
    }

    public function clear()
    {
        Logger::where('uid', Auth::id())->delete();
        return back()->with('success', __('messages.logs_cleared'));
    }
}
