<?php

namespace App\Http\Controllers\Dashboard\Tools;

use App\Http\Controllers\Controller;
use App\Models\Flow;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FlowController extends Controller
{
    public function index(Request $request)
    {
        $flows = Flow::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.tools.flows', compact('flows'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        Flow::create([
            'uid' => Auth::id(),
            'name' => $request->name,
            'data' => $request->data ? json_encode($request->data) : null,
            'enabled' => 1,
        ]);

        return back()->with('success', __('messages.flow_created'));
    }

    public function update(Request $request, Flow $flow)
    {
        $request->validate(['name' => 'required|string|max:255']);
        $flow->update([
            'name' => $request->name,
            'data' => $request->data ? json_encode($request->data) : $flow->data,
            'enabled' => $request->enabled ?? $flow->enabled,
        ]);
        return back()->with('success', __('messages.flow_updated'));
    }

    public function destroy(Flow $flow)
    {
        $flow->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
