<?php

namespace App\Http\Controllers\Dashboard\Tools;

use App\Http\Controllers\Controller;
use App\Models\Action;
use App\Models\Device;
use App\Models\WaAccount;
use App\Models\AiKey;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ActionController extends Controller
{
    public function index(Request $request)
    {
        $actions = Action::where('uid', Auth::id())
            ->orderBy('priority', 'asc')
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        $devices = Device::where('uid', Auth::id())->get();
        $waAccounts = WaAccount::where('uid', Auth::id())->where('status', 1)->get();
        $aiKeys = AiKey::where('uid', Auth::id())->get();
        
        return view('dashboard.tools.actions', compact('actions', 'devices', 'waAccounts', 'aiKeys'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|integer',
            'source' => 'required|integer',
            'event' => 'required|integer',
            'keywords' => 'required|string',
            'message' => 'required|string',
        ]);

        Action::create([
            'uid' => Auth::id(),
            'type' => $request->type,
            'source' => $request->source,
            'event' => $request->event,
            'priority' => $request->priority ?? 1,
            'match' => $request->match ?? 1,
            'ai_key' => $request->ai_key ?? 0,
            'group_trigger' => $request->group_trigger ?? 0,
            'sim' => $request->sim ?? 0,
            'device' => $request->device,
            'account' => $request->account,
            'name' => $request->name,
            'keywords' => $request->keywords,
            'message' => $request->message,
        ]);

        return back()->with('success', __('messages.action_created'));
    }

    public function update(Request $request, Action $action)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'keywords' => 'required|string',
            'message' => 'required|string',
        ]);

        $action->update($request->all());
        return back()->with('success', __('messages.action_updated'));
    }

    public function destroy(Action $action)
    {
        $action->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
